!-----------------------------------------------------------------------
!	This routine calculates the contact self-energies and broadening 
!	for a given energy (Er, Ei) in the complex plane.
!-----------------------------------------------------------------------
subroutine leads( Lead, Er, Ei, pot, Sigmar, Sigmai, Gamma )

	implicit none

	!	INTERFACE PARAMETERS 
	character(LEN=1), intent(in)  :: Lead
	real(DP),         intent(in)  :: Er, Ei, pot
	real(DP),         intent(out) :: Sigmar, Sigmai, Gamma

	!	INTERNAL PARAMETERS 
	integer             :: i, j, k, iter
	integer,  parameter :: index = 6, m = 17 
	integer             :: indx(2)
	
	real(DP), parameter :: vpi = 2.5d0
	real(DP) 					  :: ar(2,2), br(2,2), cr(2,2), dr(2,2)
	real(DP)            :: ai(2,2), bi(2,2), ci(2,2), di(2,2)
	real(DP) 					  :: cIi(2,2), cIr(2,2), temp(2,2), temp2(2,2)
	real(DP)            :: arnew(2,2), brnew(2,2), crnew(2,2), drnew(2,2)
	real(DP)            :: ainew(2,2), binew(2,2), cinew(2,2), dinew(2,2)
	real(DP)            :: cIar(2,2), cIai(2,2), cIbr(2,2), cIbi(2,2)
	real(DP) 					  :: Y(2,2), dIr(2,2), dIi(2,2)
	real(DP)            :: dummy, tmp, tempcr(2,2)

	!=================================================================

	! set left/right device-contact coupling matrices
  if ( Lead .eq. 'R' ) then
		ar      = 0.0d0
		ar(2,1) = -vpi
		ai      = 0.0d0

		br      = 0.0d0
		br(1,2) = -vpi
		bi      = 0.0d0
	else
		ar      = 0.0d0
		ar(1,2) = -vpi
		ai      = 0.0d0
		
		br      = 0.0d0
		br(2,1) = -vpi
		bi      = 0.0d0
  endif

	!	initialize real and imaginary parts of contact Hamiltonian
  cr(1,1) = Er + pot
  cr(1,2) = 2.0d0 * vpi * cos(3.1415920d0 * float(index) / float(m))
	cr(2,1) = 2.0d0 * vpi * cos(3.1415920d0 * float(index) / float(m))
 	cr(2,2) = Er + pot
 	ci = 0.0d0 ; ci(1,1) = Ei ; ci(2,2) = Ei
	
  dr(1,1) = Er + pot
  dr(1,2) = 2.0d0 * vpi * cos(3.1415920d0 * float(index) / float(m))
  dr(2,1) = 2.0d0 * vpi * cos(3.1415920d0 * float(index) / float(m))
  dr(2,2) = Er + pot
	di = 0.0d0 ; di(1,1) = Ei ; di(2,2) = Ei

	! --> main loop here: doing what ???
  do iter = 1,200
  
 		if(iter .eq. 200) then
 			print*,'iter = 200'
 		endif

		!******* calculate c inverse **********
		temp2 = cr ; temp = 0.0d0 ; tempcr = cr

		!	set r.h.s. of linear system --> unit matrix
		Y = 0.0d0 ; Y(1,1) = 1.0d0 ; Y(2,2) = 1.0d0

		! LU-decomposition of matrix --> tempcr
		call ludcmp( tempcr, 2, 2, indx, dummy )

		! solve linear matrix system: LU * x = 1
		!	to get the inverse --> Y is overwritten
		do j = 1,2
 			call lubksb( tempcr, 2, 2, indx, Y(1,j) )
		enddo

 		do i = 1,2
 			do j = 1,2
   			do k = 1,2
     			temp(i,j) = temp(i,j) + ci(i,k)*Y(k,j)
				enddo
			enddo
		enddo

    do i = 1,2
 			do j = 1,2
    		do k = 1,2
      		temp2(i,j) = temp2(i,j) + temp(i,k)*ci(k,j)
				enddo
			enddo
 		enddo

		!	set r.h.s. of linear system --> unit matrix
		Y = 0.0d0 ; Y(1,1) = 1.0d0 ; Y(2,2) = 1.0d0

		call ludcmp( temp2, 2, 2, indx, dummy )
		do j = 1,2
			call lubksb( temp2, 2, 2, indx, Y(1,j) )
		enddo

		cIr = Y
		cIi = 0.0d0
		do i = 1,2
			do j = 1,2
 				do k = 1,2
   				cIi(i,j) = cIi(i,j) - cIr(i,k)*temp(k,j)
  			enddo
 			enddo
		enddo
		
		!*********** calculate cIA ***********************
		cIar = 0.0d0
		cIai = 0.0d0
		do i = 1,2
			do j = 1,2
   			do k = 1,2
      		cIar(i,j) = cIar(i,j) + cIr(i,k)*ar(k,j) - cIi(i,k)*ai(k,j)
      		cIai(i,j) = cIai(i,j) + cIr(i,k)*ai(k,j) + cIi(i,k)*ar(k,j)
				enddo
			enddo
		enddo

		!*********** calculate cIB ***********************
		cIbr = 0.0d0
		cIbi = 0.0d0
  	do i = 1,2
  		do j = 1,2
  			do k = 1,2
      		cIbr(i,j) = cIbr(i,j) + cIr(i,k)*br(k,j) - cIi(i,k)*bi(k,j)
      		cIbi(i,j) = cIbi(i,j) + cIr(i,k)*bi(k,j) + cIi(i,k)*br(k,j)
   			enddo
			enddo
		enddo

		arnew = 0.0d0
		ainew = 0.0d0
		do i = 1,2
 			do j = 1,2
   			do k = 1,2
      		arnew(i,j) = arnew(i,j) + ar(i,k)*cIar(k,j) - ai(i,k)*cIai(k,j)
       		ainew(i,j) = ainew(i,j) + ar(i,k)*cIai(k,j) + ai(i,k)*cIar(k,j)
   			enddo
			enddo
		enddo

		brnew = 0.0d0
		binew = 0.0d0
    do i = 1,2
			do j = 1,2
   			do k = 1,2
      		brnew(i,j) = brnew(i,j) + br(i,k)*cIbr(k,j) - bi(i,k)*cIbi(k,j)
      		binew(i,j) = binew(i,j) + br(i,k)*cIbi(k,j) + bi(i,k)*cIbr(k,j)
   			enddo
			enddo
		enddo

		crnew = cr
		cinew = ci
    do i = 1,2
      do j = 1,2
   			do k = 1,2
     			crnew(i,j) = crnew(i,j) - (ar(i,k)*cIbr(k,j) - ai(i,k)*cIbi(k,j)) &
                                  - (br(i,k)*cIar(k,j) - bi(i,k)*cIai(k,j))
     			cinew(i,j) = cinew(i,j) - (ar(i,k)*cIbi(k,j) + ai(i,k)*cIbr(k,j)) &
                          				- (br(i,k)*cIai(k,j) + bi(i,k)*cIar(k,j))
   			enddo
			enddo
		enddo

		tmp   = 0.0d0
		drnew = dr
		dinew = di
		do i = 1,2
			do j = 1,2				
 				do k = 1,2
  				drnew(i,j) = drnew(i,j) - (ar(i,k)*cIbr(k,j) - ai(i,k)*cIbi(k,j))
  				dinew(i,j) = dinew(i,j) - (ar(i,k)*cIbi(k,j) + ai(i,k)*cIbr(k,j))
   			enddo

				tmp = tmp + (drnew(i,j) - dr(i,j))**2 + (dinew(i,j) - di(i,j))**2
			enddo
		enddo

		tmp = sqrt(tmp)

		!	check convergence
		if ( tmp .lt. 1.0d-16 ) then
			! EXIT THE ITER LOOP --> IS THIS CORRECT ???
			exit
		else 
			ar = arnew ; ai = ainew ; br = brnew ; bi = binew
			cr = crnew ; ci = cinew ; dr = drnew ; di = dinew
		endif

	enddo	! end-loop: iter

	temp  = 0.0d0
	temp2 = dr
	Y     = 0.0d0 ; Y(1,1) = 1.0d0 ; Y(2,2) = 1.0d0
	
	call ludcmp( dr, 2, 2, indx, dummy )
	do j = 1,2
 		call lubksb( dr, 2, 2, indx, Y(1,j) )
	enddo

  do i = 1,2
 		do j = 1,2
  		do k = 1,2
    		temp(i,j) = temp(i,j) + di(i,k)*Y(k,j)
   		enddo
		enddo
	enddo

  do i = 1,2
 		do j = 1,2
   		do k = 1,2
     		temp2(i,j) = temp2(i,j) + temp(i,k)*di(k,j)
   		enddo
		enddo
	enddo

	Y = 0.0d0 ; Y(1,1) = 1.0d0 ; Y(2,2) = 1.0d0

	call ludcmp( temp2, 2, 2, indx, dummy )
  do j = 1,2
 		call lubksb( temp2, 2, 2, indx, Y(1,j) )
	enddo

	dIr = Y
	dIi = 0.0d0
  do i = 1,2
  	do j = 1,2
   		do k = 1,2
   			dIi(i,j) = dIi(i,j) - dIr(i,k)*temp(k,j)
 			enddo
 		enddo
  enddo
  
	if ( Lead .eq. 'R' ) then
	  Sigmar = vpi**2 * dIr(1,1)
    Sigmai = vpi**2 * dIi(1,1)
	else
		Sigmar = vpi**2 * dIr(2,2)
		Sigmai = vpi**2 * dIi(2,2)
	endif

  Gamma = -2.0d0*Sigmai

	return
end subroutine leads
