!-------------------------------------------------------------------
!	This routine calculates the z-position of the tube rings
!	along with 
!-------------------------------------------------------------------
subroutine SetRingPositions( ringpos, site, l )

	implicit none
	
	!	INTERFACE PARAMETERS
	integer,  intent(in)    :: l
	integer,  intent(inout) :: site(:)
	real(DP), intent(inout) :: ringpos(:)
	
	!	INTERNAL PARAMETERS
	integer  :: i, j
	real(DP) :: ringpos2(zmax)
	
	!===================================================================

 	ringpos = 0.0d0
 	site    = 0d0
	
	ringpos(l/2+1) = acc*1e9/2.0d0
  do i = l/2+2,l
    if (mod(i,2) .eq. 0) then
    	ringpos(i) = ringpos(i-1) + 0.50d0*acc*1e9
    else
    	ringpos(i) = ringpos(i-1) + acc*1e9
    endif
  enddo

  ringpos(l/2) = -acc*1e9/2.0d0
  do i = l/2-1,1,-1
  	if (mod(i,2) .eq. 0) then
    	ringpos(i) = ringpos(i+1) - acc*1e9
    else
    	ringpos(i) = ringpos(i+1) - 0.50d0*acc*1e9
    endif
  enddo

	!	calculate positions of grid points 
  ringpos2(1) = ringpos(1) - 2.0d0*deltaz
  do i = 2,zmax
  	ringpos2(i) = ringpos2(i-1) + deltaz
 	enddo

  do i = 1,l
    do j = 1,zmax
  		if (abs( ringpos2(j) - ringpos(i) ) .lt. 0.001) then
  			site(i) = j
  		endif
		enddo
 	enddo
	
	return
end subroutine SetRingPositions
