!-----------------------------------------------------------------------
!	This routine sets up the character-string of the filename
!-----------------------------------------------------------------------
subroutine SetFileName( str1, str2, str3, str4 )

	implicit none

	!	INTERFACE PARAMETERS
	character (len=2), intent(inout) :: str1
	character (len=5), intent(inout) :: str2, str3
	character (len=3), intent(inout) :: str4
	
	!	INTERNAL PARAMETERS
	integer  :: i, j, k, NG, channel
	real(DP) :: distance
	
	!=====================================================================
	
  NG        = (zmax - 2*Nxi - 1)
  channel   = int(float(NG)*deltaz)
  i         = int(channel/10)
  str1(1:1) = string(i+1:i+1)
  j         = int(channel-i*10)
  str1(2:2) = string(j+1:j+1)
 
  if (VGMIN .ge. 0.0) then
  
  	str2(1:1) = '+'
  
  	if(VGMIN .lt. 10) then
  		i         = int(VGMIN)
  		str2(2:2) = string(i+1:i+1)
  		j         = int(10.*(VGMIN-i))
  		str2(4:4) = string(j+1:j+1)
  		str2(3:3) = '.'
  		k         = int(100.0*(VGMIN - float(i) - float(j)))
  		str2(5:5) = string(k+1:k+1)
  	else 
  		i         = int(VGMIN/10)
  		str2(2:2) = string(i+1:i+1)
  		j         = int(VGMIN - i*10)
  		str2(3:3) = string(j+1:j+1)
  		k         = int(10.0*(VGMIN - float(i)*10.0 - float(j)))
  		str2(5:5) = string(k+1:k+1)
  		str2(4:4) = '.'
  	endif
 
  else
  
  	str2(1:1) = '-'
  	
  	if (VGMIN .gt. -10.0) then
  		i         = int(-VGMIN)
  		str2(2:2) = string(i+1:i+1)
  		j         = int(-10.0*(VGMIN+i))
  		str2(4:4) = string(j+1:j+1)
  		str2(3:3) = '.'
     	k         = int(-100.0*(VGMIN + float(i) + float(j)))
  		str2(5:5) = string(k+1:k+1)
  	else 
  		i         = int(-VGMIN/10)
  		str2(2:2) = string(i+1:i+1)
  		j         = int(VGMIN+i*10)
  		str2(3:3) = string(j+1:j+1)
  		k         = int(10.0*(VGMIN + float(i)*10.0 + float(j)))
  		str2(5:5) = string(k+1:k+1)
  		str2(4:4) = '.'
  	endif
  endif
 
  if (VDS .ge. 0.0) then
  	str3(1:1) = '+'
  	i         = int(VDS)
  	str3(2:2) = '0'
  	j         = int(10.0*(VDS-i))
  	str3(4:4) = string(j+1:j+1)
  	str3(3:3) = '.'
  	k         = int(100.0*(VDS - float(i) - float(j)))
  	str3(5:5) = string(k+1:k+1)
  else
    str3(1:1) = '-'
    i         = int(-VDS)
    str3(2:2) = '0'
    j         = int(-10.0*(VDS+i))
    str3(4:4) = string(j+1:j+1)
    str3(3:3) = '.'
    k         = int(VDS*10 + float(i) + float(j))
    str3(5:5) = string(k+1:k+1)
  endif
 
  distance = rmax*deltar
  
  if (distance .lt. 10.0) then
		i         = int(distance)
  	str4(1:1) = string(i+1:i+1)
  	j         = int(10.0*(distance - i))
  	str4(3:3) = string(j+1:j+1)
  	str4(2:2) = '.'
  else 
  	i         = int(distance/10)
  	print*,i
  	str4(1:1) = string(i+1:i+1)
  	j         = int(distance - i*10)
  	print*,j
  	str4(2:2) = string(j+1:j+1)
  	str4(3:3) = '.'
  endif
 	
  return
end subroutine SetFileName
