! precision declarations
integer,  parameter :: DP = kind(1.0d0)	
  
! mathematical constants
real(DP),    parameter :: pi        = 3.14159265	  ! ACOS(-1.0d0)
real(DP),    parameter :: twopi 	  = 2*pi
real(DP),    parameter :: one_pi    = 1.0d0/pi
real(DP),    parameter :: one_twopi = 1.0d0/twopi

! electrical and physical constants
real(DP), parameter :: hPlanck = 6.626*1e-34		! Planck constant : [Js]
real(DP), parameter :: hbar    = hPlanck/twopi	! normalized Planck constant : [Js]
real(DP), parameter :: qe      = 1.602*1e-19    ! charge of electron : [C]

!	contour integration
real(DP),    parameter :: eta_contour = 1.0e-6
real(DP),    parameter :: eta_device  = 1.0e-6

!	conversion to unit [eV]
real(DP) :: hbar_eV = hbar / qe
