!******* Self-consistent calculations of charge and potential for a
!******* planar metal/semiconductor interface
!******* x is the direction parallel to the interface
!******* z is the direction perpendicular to interface

      integer xmax,zmax,hp,Nmax_scf
      
!****** number of grid points

! xmax is lateral size; PBC and uniformity means it shouldn't matter
! zmax is giving the length along the direction perp to metal interface      
      parameter(xmax=6,zmax=2200)
	
      double precision a(xmax,zmax),b(xmax,zmax),c(xmax,zmax)
      double precision d(xmax,zmax),rjac,elec(xmax,zmax),hole(xmax,zmax)
      double precision e(xmax,zmax),Ec(xmax,zmax),p_doping,n_doping
      double precision u(xmax,zmax),VS,VF,T,kT,m_eff_c,m_eff_v
      double precision eps,pi,VDS,Ni,pot,EF_doping,plank
      double precision dip(xmax,zmax),chg(zmax)
      double precision charge2d(xmax,zmax),charge2dnew(xmax,zmax)
      double precision deltax,deltay,deltaz,Nc,Nv,s,ss,p_thickness
      double precision dipole,sigma,z1,z2,z3,z4,z5,z6,z7
      double precision d1,d2,d3,d4,d5,d6,d7,factor,aa,bb
	
!***** deltax and deltaz are the grid spacings
!***** sigma is the gaussian width of the added chemical dipole charges
!***** frac is the mixing parameter in the simple mixing for convergence
     	
      parameter(deltax=1.*1e-6,deltaz=0.05e-10,sigma=2.0e-11)
      parameter(T=300,frac=1.e-2)
      
!*****  eps is the semiconductor dielectric constant
!*****  Eg is the semiconductor bandgap
!*****  p_doping is the doping in cm^-3
!*****  dipole is the strength of the chemical diple charges      

	parameter(epsilon=8.85E-12,el=1.6E-19)
	parameter(rjac=0.99999990d0,eps=24.0d0,Eg=0.34)
	parameter(pi=3.1415920d0,plank=6.626e-34)
	parameter(p_doping=-0.0e20,dipole=1.e23)
	
!***** effective mass parameters for different cases
	
!this for 12x12x8       
        parameter(E_aff=4.78,W_M=4.5,m_eff_c=1.6*9.11e-31,m_eff_v=3.2*9.11e-31) 
!        parameter(E_aff=4.78,W_M=4.5,m_eff_c=3.4*9.11e-31,m_eff_v=3.8*9.11e-31)
	
	open(10,file='chg.dat')
        chg=0.d0
        do k=1,zmax
        read(10,*) aa,bb
         if (aa.le.101.5d0)  chg(k)=bb*eps 
        enddo

!*** set boundary condition at metal/semiconductor interface

        VC= E_aff - W_M + Eg/2   !potential of E_F at contact wrt midgap
        VC=0.417                !fix the potential instead

!**********************************************************	
	
	Ec0=Eg/2
	
	kT=1.38e-23*T/1.6e-19

        Nc=8*pi*sqrt(2.)*(m_eff_c/plank**2*kT*1.6e-19)**1.5/1e6
        Nv=8*pi*sqrt(2.)*(m_eff_v/plank**2*kT*1.6e-19)**1.5/1e6
        
        print*,Nc,Nv

	hp=zmax/2
	
	Ni=sqrt(Nc*Nv)*exp(-Eg/(2*kT))
	
	NcL=xmax/2-(w+channel/2.)/deltax
	NcR=NcL+(w+channel)/deltax
	Nw=w/deltax+1

!******* coefficients in potential diff. eq. *********

      do 10 i=1,xmax
      do 20 j=1,zmax
	a(i,j)=1.0d0
	b(i,j)=1.0d0
      c(i,j)=1.0d0*(deltax/deltaz)**2
      d(i,j)=1.0d0*(deltax/deltaz)**2
      e(i,j)=-2.0d0-2.0d0*(deltax/deltaz)**2

! coefficients of Poisson eq: 
! (a*V_i+1,j + b*V_i-1,j - 2*V_i,j)/dx^2+(c*V_i,j+1 + d*V_i,j-1 - 2*Vi,j)/dz^2 = rho_i,j

! Boundary conditions: bottom is metal interface
!******** fixed potential at top of cell ****
!      if(j.ge.zmax-1)then
!      a(i,j)=0.0d0
!	b(i,j)=0.0d0
!	c(i,j)=0.0d0
!	d(i,j)=0.0d0
!	e(i,j)=0.0d0
!      endif

! Instead we impose zero derivative at infty...
      if(j.eq.zmax-1)then
	c(i,j)=0.0d0
	d(i,j)=2.0e-00*d(i,j)
	endif
      
!******** fixed potential at bottom of cell ****
      if(j.le.2)then
      a(i,j)=0.0d0
	b(i,j)=0.0d0
	c(i,j)=0.0d0
	d(i,j)=0.0d0
	e(i,j)=0.0d0
      endif

!      if(j.eq.2)then
!	c(i,j)=0.0d0
!	d(i,j)=d(i,j)+1.0d0
!	endif


!******** zero derivative at left boundary **
      if(i.eq.2)then
	b(i,j)=0.0d0
	a(i,j)=a(i,j)+1.0d0
	endif

!******** zero derivative at right boundary **
	if(i.eq.xmax-1)then
	a(i,j)=0.0d0
	b(i,j)=b(i,j)+1.0d0
	endif

 20   continue
 10   continue

!************************************************

!**** figure out position of Fermi level for given doping ***
!***** pot is the electros. potential. pot=0 means Fermi level at midgap

        old = +1
        if(p_doping.lt.0.)old=-1

    do iter=1,5000
   
	pot = -old*float(iter) *0.0001+0.1
	
	 call qtrap(0.d0,30.0d0,-(Ec0-pot)/kT,s)
	 call qtrap(0.d0,30.0d0,(Ec0-pot)/kT-Eg/kT,ss)
	 
	 chargetot=Nc*s-Nv*ss+p_doping

!        write(18,*)pot+Eg/2.,chargetot-p_doping,Nc*s,Nv*ss
	
	if(old*chargetot.lt.0)then
	Ef_doping = pot
!	print*,iter
	goto 6
	endif
	
	new=chargetot

    enddo
    
6     continue

      VF=Ef_doping

      print*,'VF=',VF
      
      Vbi=VC-VF
      
!**** initial guess for depletion width
      
!      W=sqrt(2.*eps*(epsilon)*(Vbi/1.6e-19)/(abs(p_doping)*1e6)) !W in meters

      W=10e-10     !
      
      write(*,*)'Vbi=',Vbi,'eV ','W=', W/1e-9,'nanometers'
      
      
!**** boundary conditions for potential ***

      do i=1,xmax
       u(i,1)=VC
!       u(i,zmax)=VF
      enddo

!**** initial guess for the potential ***

! setting VF=VC here would make convergence faster for no free carriers case
!      VF=VC
      do i=1,xmax
	do k=2,zmax-1
	 u(i,k)=VF
	 if(deltaz*float(k).lt.W)then
	  u(i,k)=VC+deltaz*float(k)*(VF-VC)/W
	 endif
!        u(i,k)=VC
	Ec(i,k)=Ec0-u(i,k)
	enddo
      enddo
! final value of potential at the very top(k=zmax) interface will remain fixed at the value below.
! should not matter for the other z positions, it just creates a discontinuity between zmax-1 and zmax.  
      u=VC
!**** dipole distribution

        z1=1.e-10
        z2=z1+1.0e-10
        z3=z1+2.3e-10
        z4=z1+3.5e-10
        z5=z1+5.2e-10
        z6=z1+7.0e-10
        z7=z1+9.0e-10

         factor=0.5e-00
        d1=7.5*factor
        d2=1.45*factor
        d3=0.5*factor
        d4=0.2*factor
        d5=0.1*factor
        d6=0.05*factor
        d7=0.15*factor
        
       do i=1,xmax
	do k=1,zmax
        dip(i,k)=chg(k)
!        write(15,*)k*deltaz,dip(1,k)
        enddo
       enddo


!*********initial guess for the charge******************

       do i=1,xmax
	do k=1,zmax
	
	 call qtrap(0.d0,30.0d0,-Ec(i,k)/kT,s)
	 call qtrap(0.d0,30.0d0,Ec(i,k)/kT-Eg/kT,ss)
	 
	 elec(i,k)=Nc*s
	 	 
	 hole(i,k)=Nv*ss
	 
	 charge2d(i,k)=elec(i,k)-hole(i,k)+p_doping
	 
	enddo
	enddo
	
	do i=1,xmax
	 do k=1,zmax
	 
!  Next line to be used in Step 1     
!  charge2d(i,k)=charge2d(i,k)*0.0e-00+dip(i,k)
     charge2d(i,k)=charge2d(i,k)*1.0e-00+dip(i,k)
       
	 enddo
	enddo
	
!*** begin self-consistent loop ****      
! Nmax_scf is the # of self-consistent loops
      Nmax_scf=200
      do iter=1,Nmax_scf
      if(mod(iter,2).eq.0)write(*,*) 'SCF iter #',iter

!******************************************

!********* Calculate potential ************

      call sor(a,b,c,d,e,-charge2d*deltax**2*(-1.6e-19/(eps*epsilon))*1e6,u,xmax,zmax,rjac)	
	
!*********Shift band edge **********************************	

       do i=1,xmax
	do k=1,zmax
	
	 Ec(i,k)=Ec0-u(i,k)
	enddo
	enddo
	 
	 
!*********calculate charge******************

       do i=1,xmax
	do k=1,zmax
	
	 call qtrap(0.d0,30.0d0,-Ec(i,k)/kT,s)
	 call qtrap(0.d0,30.0d0,Ec(i,k)/kT-Eg/kT,ss)
	 
	 elec(i,k)=Nc*s
	 	 
	 hole(i,k)=Nv*ss
	 
	 charge2dnew(i,k)=elec(i,k)-hole(i,k)+p_doping
	 
	enddo
	enddo
	
	do i=1,xmax
	do k=1,zmax

!  Next line to be used in Step 1     
!  charge2dnew(i,k)=charge2dnew(i,k)*0.0e-00+dip(i,k)   
         charge2dnew(i,k)=charge2dnew(i,k)*1.0e-00+dip(i,k)
        
	enddo
	enddo
	
	do i=1,xmax
	do k=1,zmax
	
	charge2d(i,k)=(1-frac)*charge2d(i,k)+frac*charge2dnew(i,k)
	
	enddo
	enddo
	
      enddo
      
5     continue
      
       do i=1,xmax
	do k=1,zmax
	 write(11,*)i,k,elec(i,k),hole(i,k),charge2d(i,k)
	 write(12,*)i,k,u(i,k)
	enddo
	enddo
	
	do k=1,zmax
	 write(13,'(5e15.5)') k*deltaz/1e-10,-u(xmax/2,k),elec(xmax/2,k),hole(xmax/2,k),charge2d(xmax/2,k)
         write(130,'(5e15.5)') k*deltaz/1e-10,-u(xmax/2,k),elec(xmax/2,k),hole(xmax/2,k),charge2dnew(xmax/2,k)
	enddo
      
      stop
      end
       
      SUBROUTINE sor(a,b,c,d,e,f,u,jmax,lmax,rjac)
!****** note: I have modified this routine **********
      INTEGER jmax,lmax,MAXITS
      DOUBLE PRECISION rjac,a(jmax,lmax),b(jmax,lmax),c(jmax,lmax), &
      d(jmax,lmax),e(jmax,lmax),f(jmax,lmax),u(jmax,lmax),EPS
! if one increases MAXITS one can decrease Nmax_scf
      PARAMETER (MAXITS=100000,EPS=1.E-5)
      INTEGER ipass,j,jsw,l,lsw,n
      DOUBLE PRECISION anorm,anormf,omega,resid
      anormf=0.0d0
      do 12 j=2,jmax-1
        do 11 l=2,lmax-1
          resid=a(j,l)*u(j+1,l)+b(j,l)*u(j-1,l)+c(j,l)*u(j,l+1)+d(j, &
      l)*u(j,l-1)+e(j,l)*u(j,l)-f(j,l)
          anormf=anormf+dabs(resid)
11      continue
12    continue
      omega=1.d0
      do 16 n=1,MAXITS
        anorm=0.0d0
        jsw=1
        do 15 ipass=1,2
          lsw=jsw
          do 14 j=2,jmax-1
            do 13 l=lsw+1,lmax-1,2
	       if(e(j,l).ne.0.0d0)then
           resid=a(j,l)*u(j+1,l)+b(j,l)*u(j-1,l)+c(j,l)*u(j,l+1)+d(j, &
      l)*u(j,l-1)+e(j,l)*u(j,l)-f(j,l)
              anorm=anorm+dabs(resid)
              u(j,l)=u(j,l)-omega*resid/e(j,l)
	        else
	        u(j,l)=u(j,l)
	        endif
13          continue
            lsw=3-lsw
14        continue
          jsw=3-jsw
          if(n.eq.1.and.ipass.eq.1) then
            omega=1.0d0/(1.0d0-0.5d0*rjac**2)
          else
            omega=1.0d0/(1.0d0-0.25d0*rjac**2*omega)
          endif
15      continue
!       print*,n,'anorm=',anorm
        if(anorm.le.EPS*anormf.or.anormf.eq.0.0)then
!	  print*,n
	  return
	  endif
16    continue
      pause 'MAXITS exceeded in sor'
      return
      END
      
      SUBROUTINE func(x,xf,f)
      double precision x,f,xf
      f=sqrt(x)/(1.+exp(x-xf))
!      f=x
!      write(*,*)x,xf,f
!      pause
      return
      end
      

      SUBROUTINE qtrap(a,b,xf,s)
      INTEGER JMAX
      double precision a,b,s,EPS,xf
      PARAMETER (EPS=1.e-3,JMAX=40)
!    USES trapzd
      INTEGER j
      double precision olds
      
      olds=-1.e30
      do 11 j=1,JMAX
        call trapzd(a,b,xf,s,j)
        if (abs(s-olds).lt.EPS*abs(olds)) return
        if (s.eq.0..and.olds.eq.0..and.j.gt.6) return
        olds=s
11    continue
      pause 'too many steps in qtrap'
      END

      SUBROUTINE trapzd(a,b,xf,s,n)
      INTEGER n
      double precision a,b,s,xf,d,f1,f2
      INTEGER it,j
      double precision del,sum,tnm,x,f
      if (n.eq.1) then
        call func(a,xf,f1)
        call func(b,xf,f2)
        s=0.5*(b-a)*(f1+f2)     
      else
        it=2**(n-2)
        tnm=it
        del=(b-a)/tnm
        x=a+0.5*del
        sum=0.
        do 11 j=1,it
          call func(x,xf,f)
          sum=sum+f
          x=x+del
11      continue
        s=0.5*(s+(b-a)*sum/tnm)
!           write(*,*)s
!        pause
      endif
      return
      END

	

