#
# Usage: ctest -S ctest_nightly_mpi_divcurl.cmake [-DOPT:BOOL=YES] [-DMODEL:STRING=Nightly]
#
#   -DTYPE:STRING=<OPT|DBG> -- Compiles using optimization (default is debug build)
#   -DPROCESSORCOUNT:INT=<number of processors for parallel make> (Example: -DPROCESSORCOUNT:INT=10)
#   -DROOTDIR:STRING=<root build directory>
#   -DBOOSTINCDIR:STRING=<Boost include directory>
#   -DBOOSTLIBDIR:STRING=<Boost library directory>
#   -DNETCDFINCDIR:STRING=<NetCDF include directory>
#   -DNETCDFLIBDIR:STRING=<NetCDF include directory>
#
# This is a ctest script for running Charon nightly tests
SET(TCAD_CHARON_REPO       "git@cee-gitlab.sandia.gov:Charon/tcad-charon")
SET(SRC_REPO               "git@cee-gitlab.sandia.gov:Charon/src")
SET(NIGHTLY_TESTS_REPO     "git@cee-gitlab.sandia.gov:Charon/nightlyTests")
SET(TRILINOS_REPO          "git@cee-gitlab.sandia.gov:Charon/Trilinos")

SET(TCAD_CHARON_SOURCE_DIRECTORY "${ROOTDIR}/tcad-charon")
SET(SRC_DIRECTORY                "${TCAD_CHARON_SOURCE_DIRECTORY}/src")
SET(NIGHTLY_TESTS_DIRECTORY      "${TCAD_CHARON_SOURCE_DIRECTORY}/test/nightlyTests")
SET(TRILINOS_SOURCE_DIRECTORY    "${TCAD_CHARON_SOURCE_DIRECTORY}/Trilinos")

SET(CTEST_SOURCE_DIRECTORY "${TCAD_CHARON_SOURCE_DIRECTORY}")

# For now just hardcode these for now
SET(COMPILER "MPI_GCC_6.1.x")

SET(DISTRIB "Jenkins")

# The location of extra software, namely netcdf and boost

####################################################################
####################################################################
# Nothing below this needs to be modified for other Linux platforms
# with the possible exception of the host-specific settings
####################################################################
####################################################################
if(${TYPE} MATCHES OPT)
  SET(CTEST_BINARY_DIRECTORY "${ROOTDIR}/TEST.OPT")
else()
  SET(CTEST_BINARY_DIRECTORY "${ROOTDIR}/TEST.DBG")
endif()

# Get some information about the platform to name this test run
FIND_PROGRAM(UNAME NAMES uname)
MACRO(getuname name flag)
  EXECUTE_PROCESS(COMMAND "${UNAME}" "${flag}"
    OUTPUT_VARIABLE "${name}"
    OUTPUT_STRIP_TRAILING_WHITESPACE)
ENDMACRO()

getuname(osname -s)
getuname(proc -m)

FIND_PROGRAM(HNAME NAMES hostname)
EXECUTE_PROCESS(COMMAND "${HNAME}" "-f"
  OUTPUT_VARIABLE myhost
  OUTPUT_STRIP_TRAILING_WHITESPACE)

FIND_PROGRAM(CTEST_GIT_COMMAND NAMES git)

SET(CTEST_SITE "JBF RHEL6 Build Only")

#########################################
# Any host specific settings go here
#########################################
if (${myhost} MATCHES "s979530.sandia.gov")
  # Installed AMD optimized BLAS and LAPACK in this directory for
  # RHEL 6.5
  SET(CMAKEHOSTDEFS "-D BLAS_LIBRARY_NAMES:STRING=clBLAS\\ acml")
  SET(CMAKEHOSTDEFS "${CMAKEHOSTDEFS} -D BLAS_LIBRARY_DIRS:STRING=/home/glhenni/Software/acml/gfortran64/lib")
  SET(CMAKEHOSTDEFS "${CMAKEHOSTDEFS} -D LAPACK_LIBRARY_NAMES:STRING=acml")
  SET(CMAKEHOSTDEFS "${CMAKEHOSTDEFS} -D LAPACK_LIBRARY_DIRS:STRING=/home/glhenni/Software/acml/gfortran64/lib")
  MESSAGE("CMAKEHOSTDEFS=" ${CMAKEHOSTDEFS})
endif()

if(${TYPE} MATCHES OPT)
  SET(CTEST_BUILD_NAME "${osname}-${proc}-${DISTRIB}-${COMPILER}-OPT")
else()
  SET(CTEST_BUILD_NAME "${osname}-${proc}-${DISTRIB}-${COMPILER}-DBG")
endif()

MESSAGE("Build name: ${CTEST_BUILD_NAME}")

FIND_PROGRAM(CTEST_MEMORYCHECK_COMMAND NAMES valgrind)

# This is supposed to invoke make with "-j <processor count>" but
# somewhere during the build process this is frustratingly reset. This
# makes the testing process take a large amount of time because of the
# serial compile during part of the build.
if (NOT PROCESSORCOUNT)
  SET(PROCESSORCOUNT 1)
endif()

SET(CTEST_BUILD_FLAGS "-j${PROCESSORCOUNT}")

# This needs to be set because of CTestConfig.cmake in Trilinos
SET(CMAKE_MODULE_PATH
  "${TRILINOS_SOURCE_DIRECTORY}/cmake/tribits/core/utils")

SET(CTEST_CMAKE_GENERATOR "Unix Makefiles")
SET(CTEST_PROJECT_NAME "Charon")

# The Jenkins servers do the update so avoid doing it here.
SET(CTEST_UPDATE_COMMAND "/bin/true")
SET(CTEST_CMAKE_COMMAND "${CMAKE_COMMAND}")

MESSAGE("cmake command: ${CTEST_CMAKE_COMMAND}")

# Begin setting the options controlling the build of Charon
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CMAKE_COMMAND} ${CMAKEHOSTDEFS}")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_PyTrilinos:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_VERBOSE_CONFIGURE:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_DEBUG:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_INSTALL_CMAKE_CONFIG_FILES:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_CHECKED_STL:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_TEUCHOS_TIME_MONITOR:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_ALL_PACKAGES:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_EXAMPLES:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_SECONDARY_TESTED_CODE:BOOL=OFF")

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_SEACASEx1ex2v2:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_SEACASEx2ex1v2:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_SEACASExomatlab:BOOL=OFF")

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_Ifpack2:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_Tempus:BOOL=OFF")

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_STKUnit_test_utils:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_STKSearch:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_STKSearchUtil:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_STKUnit_tests:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_STKDoc_tests:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_STKExprEval:BOOL=OFF")

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_EXPLICIT_INSTANTIATION:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_TESTS:BOOL=OFF")

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D NOX_ENABLE_TEUCHOS_TIME_MONITOR:BOOL=ON")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Intrepid2_ENABLE_DEBUG_INF_CHECK:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Teuchos_ENABLE_LONG_LONG_INT:BOOL=ON")

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D SEACASExodus_ENABLE_MPI:BOOL=OFF")

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D TPL_ENABLE_MPI:BOOL=ON")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D TPL_ENABLE_Matio:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D TPL_ENABLE_X11:BOOL=OFF")

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_Charon:BOOL=ON")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_Stokhos:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_MueLu:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_Zoltan2:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_Amesos2:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_ROL:BOOL=OFF")

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_KokkosAlgorithms:BOOL=ON")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D tcad-charon_ENABLE_KokkosCore:BOOL=ON")

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Phalanx_EXPLICIT_TEMPLATE_INSTANTIATION:BOOL=ON")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Phalanx_KOKKOS_DEVICE_TYPE:STRING=SERIAL")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Phalanx_INDEX_SIZE_TYPE:STRING=INT")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Phalanx_SHOW_DEPRECATED_WARNINGS:BOOL=OFF")

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Kokkos_ENABLE_Serial:BOOL=ON")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Kokkos_ENABLE_OpenMP:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Kokkos_ENABLE_Pthread:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Kokkos_ENABLE_Cuda:BOOL=OFF")

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Panzer_ENABLE_EXPLICIT_INSTANTIATION:BOOL=ON")

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Charon_ENABLE_TESTS:BOOL=ON")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Charon_ENABLE_EXAMPLES:BOOL=ON")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Charon_ENABLE_DEBUG:BOOL=ON")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Charon_ENABLE_EXPLICIT_INSTANTIATION:BOOL=ON")

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D CMAKE_VERBOSE_MAKEFILE:BOOL=OFF")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D CMAKE_BUILD_TYPE:STRING=NONE")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D CMAKE_SKIP_RULE_DEPENDENCY=ON")

# Platform dependent settings
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D CMAKE_CXX_COMPILER:FILEPATH=mpic++")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D CMAKE_C_COMPILER:FILEPATH=mpicc")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D CMAKE_Fortran_COMPILER:FILEPATH=mpif77")

if(${TYPE} MATCHES OPT)

  # Turn off warnings for Mac. They seem to confuse ctest/cdash when
  # there are too many of them
  if(${osname} MATCHES "Darwin")
    SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D CMAKE_CXX_FLAGS:STRING=-O3\\ -std=c++11\\ -w")
    SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D CMAKE_C_FLAGS:STRING=-O3\\ -w")
  else()
    SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D CMAKE_CXX_FLAGS:STRING=-O3\\ -std=c++11")
    SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D CMAKE_C_FLAGS:STRING=-O3")
  endif()

  SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D CMAKE_Fortran_FLAGS:STRING=-O3")
else()

  # Turn off warnings for Mac. They seem to confuse ctest/cdash when
  # there are too many of them
  if(${osname} MATCHES "Darwin")
    SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D CMAKE_CXX_FLAGS:STRING=-g\\ -std=c++11\\ -w")
    SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D CMAKE_C_FLAGS:STRING=-g\\ -w")
  else()
    SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D CMAKE_CXX_FLAGS:STRING=-g\\ -std=c++11\\ -Wall")
    SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D CMAKE_C_FLAGS:STRING=-g\\ -Wall")
  endif()

  SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D CMAKE_Fortran_FLAGS:STRING=-g")
endif()

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D TPL_ENABLE_Boost:BOOL=ON")
SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D TPL_ENABLE_BoostLib:BOOL=ON")
if ("${BOOSTINCDIR} " STREQUAL " ")
else()
  SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Boost_INCLUDE_DIRS:FILEPATH=${BOOSTINCDIR}")
  SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D BoostLib_INCLUDE_DIRS:FILEPATH=${BOOSTINCDIR}")
endif()
if ("${BOOSTLIBDIR} " STREQUAL " ")
else()
  SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D BoostLib_LIBRARY_DIRS:FILEPATH=${BOOSTLIBDIR}")
endif()

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D TPL_ENABLE_Netcdf:BOOL=ON")
if ("${NETCDFINCDIR} " STREQUAL " ")
else()
  SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D TPL_Netcdf_INCLUDE_DIRS:PATH=${NETCDFINCDIR}")
endif()
if ("${NETCDFLIBDIR} " STREQUAL " ")
else()
  SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D Netcdf_LIBRARY_DIRS:PATH=${NETCDFLIBDIR}")
endif()

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D TPL_ENABLE_HDF5:BOOL=OFF")
# End platform dependent settings

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -D MEMORYCHECK_COMMAND:FILEPATH=${CTEST_MEMORYCHECK_COMMAND}")

SET(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} \"${CTEST_SOURCE_DIRECTORY}\"")

SET(CTEST_CUSTOM_MAXIMUM_PASSED_TEST_OUTPUT_SIZE 524288)
SET(CTEST_CUSTOM_MAXIMUM_FAILED_TEST_OUTPUT_SIZE 1048576)

SET(CMAKE_INSTALL_PATH:PATH=${WORKSPACE})
SET(CMAKE_INSTALL_PREFIX:PATH=${WORKSPACE})


# Ignore certain build warnings as far as CDash is concerned
#
# "Type mismatch" - FORTRAN warnings/errors in non-charon packages
#
#
SET(CTEST_CUSTOM_WARNING_EXCEPTION
  ${CTEST_CUSTOM_WARNING_EXCEPTION}
  "Trilinos/packages"
  "unique_ptr.h:49:28: note: declared here"
  "boost/.*\\.hpp.*: warning:"
  "boost/.*\\.hpp.*: note:"
  )

# Some Mac specific warnings for CDash to ignore
if(${osname} MATCHES "Darwin")
  SET(CTEST_CUSTOM_WARNING_EXCEPTION
    ${CTEST_CUSTOM_WARNING_EXCEPTION}
    "ranlib: file: lib.*has no symbols"
    "ranlib: warning for library: lib.*the table of contents is empty"
    "_stdio.h:50:56: note: expanded from macro 'sprintf'"
    "note: in expansion of macro.*BOOST"
    "note: in definition of macro.*BOOST"
    "open-mpi/1.7.4/include/mpi.h.*")
endif()

# Clean out the build directory to start with a fresh build
ctest_empty_binary_directory(${CTEST_BINARY_DIRECTORY})

SET(CTEST_MODEL "Nightly TRACK Heavy")

# Start the testing process
ctest_start(${CTEST_MODEL})

ctest_upload(FILES ${buildxml} ${configurexml} ${testxml})
